import { type MaybeDeref } from "@thi.ng/api/deref";
import type { Transducer } from "./api.js";
/**
 * Sliding window transducer, similar to `partition(size, 1)`, but supports
 * initially partially filled windows, if `partial` is set to true (default).
 * Each emitted window is a shallow copy of the internal accumulation buffer.
 *
 * @remarks
 * If `size` implements
 * [`IDeref`](https://docs.thi.ng/umbrella/api/interfaces/IDeref.html), the
 * window size will be re-evaluated for each new input and therefore can be used
 * as mechanism to dynamically adjust the window size.
 *
 * Also see {@link partition}.
 *
 * @example
 * ```ts tangle:../export/sliding-window.ts
 * import { range, slidingWindow } from "@thi.ng/transducers";
 *
 * console.log(
 *   [...slidingWindow(3, range(5))]
 * );
 * // [ [ 0 ], [ 0, 1 ], [ 0, 1, 2 ], [ 1, 2, 3 ], [ 2, 3, 4 ] ]
 *
 * console.log(
 *   [...slidingWindow(3, false, range(5))]
 * );
 * // [ [ 0, 1, 2 ], [ 1, 2, 3 ], [ 2, 3, 4 ] ]
 * ```
 *
 * @param size -
 * @param partial -
 */
export declare function slidingWindow<T>(size: MaybeDeref<number>, partial?: boolean): Transducer<T, T[]>;
export declare function slidingWindow<T>(size: MaybeDeref<number>, src: Iterable<T>): IterableIterator<T[]>;
export declare function slidingWindow<T>(size: MaybeDeref<number>, partial: boolean, src: Iterable<T>): IterableIterator<T[]>;
//# sourceMappingURL=sliding-window.d.ts.map