import type { IRandom } from "@thi.ng/random";
import type { Transducer } from "./api.js";
export interface StreamShuffleOpts {
    /**
     * Sliding window size
     */
    n: number;
    /**
     * Max. shuffle ops per new input (in [0..n] range)
     *
     * @defaultValue same as `n`
     */
    max?: number;
    /**
     * PRNG instance to use for shuffling
     *
     * @defaultValue SYSTEM
     */
    rnd?: IRandom;
}
/**
 * Transducer. Creates internal sliding window of `n` values and performs
 * `maxSwaps` random shuffle operations for each new value and yields values in
 * shuffled order. By default `maxSwaps` is the same as the chosen chunk size.
 * If given a {@link StreamShuffleOpts} options object, further configurations
 * are possible.
 *
 * @example
 * ```ts tangle:../export/stream-shuffle.ts
 * import { range, streamShuffle } from "@thi.ng/transducers";
 * import { XsAdd } from "@thi.ng/random";
 *
 * console.log(
 *   [...streamShuffle(5, range(10))]
 * );
 * // [ 3, 2, 5, 0, 8, 7, 1, 6, 4, 9 ]
 *
 * console.log(
 *   [...streamShuffle({ n: 5, rnd: new XsAdd(12345) }, range(10))]
 * );
 * [ 0, 4, 3, 7, 8, 1, 5, 2, 6, 9 ]
 * ```
 *
 * @param n - sliding window size
 * @param maxSwaps - number of swaps per input
 */
export declare function streamShuffle<T>(n: number, maxSwaps?: number): Transducer<T, T>;
export declare function streamShuffle<T>(opts: StreamShuffleOpts): Transducer<T, T>;
export declare function streamShuffle<T>(opts: number | StreamShuffleOpts, src: Iterable<T>): IterableIterator<T>;
export declare function streamShuffle<T>(n: number, maxSwaps: number, src: Iterable<T>): IterableIterator<T>;
//# sourceMappingURL=stream-shuffle.d.ts.map