import { isIterable } from "@thi.ng/checks/is-iterable";
import { comp } from "./comp.js";
import { iterator } from "./iterator.js";
import { mapKeys } from "./map-keys.js";
import { partitionOf } from "./partition-of.js";
import { partition } from "./partition.js";
import { rename } from "./rename.js";
function struct(fields, src) {
  return isIterable(src) ? iterator(struct(fields), src) : comp(
    partitionOf(fields.map((f) => f[1])),
    partition(fields.length),
    rename(fields.map((f) => f[0])),
    mapKeys(
      fields.reduce(
        (acc, f) => f[2] ? (acc[f[0]] = f[2], acc) : acc,
        {}
      ),
      false
    )
  );
}
export {
  struct
};
