import type { Transducer } from "./api.js";
/**
 * Transducer which only yields every `n`-th value from the input
 * source.
 *
 * @example
 * ```ts tangle:../export/take-nth.ts
 * import { range, takeNth } from "@thi.ng/transducers";
 *
 * console.log(
 *   [...takeNth(3, range(10))]
 * );
 * // [ 0, 3, 6, 9 ]
 * ```
 *
 * @param n -
 */
export declare function takeNth<T>(n: number): Transducer<T, T>;
export declare function takeNth<T>(n: number, src: Iterable<T>): IterableIterator<T>;
//# sourceMappingURL=take-nth.d.ts.map