import { isIterable } from "@thi.ng/checks/is-iterable";
import { iterator1 } from "./iterator.js";
import { throttle } from "./throttle.js";
function throttleTime(delay, src) {
  return isIterable(src) ? iterator1(throttleTime(delay), src) : throttle(() => {
    let last = 0;
    return () => {
      const t = Date.now();
      return t - last >= delay ? (last = t, true) : false;
    };
  });
}
export {
  throttleTime
};
