import type { StatefulPredicate } from "@thi.ng/api";
import type { Transducer } from "./api.js";
/**
 * Similar to {@link filter}, but works with possibly stateful predicates to
 * achieve rate limiting capabilities. Emits only values when predicate returns
 * a truthy value.
 *
 * @remarks
 * To support multiple instances of stateful predicates, the predicate itself
 * must be wrapped in a no-arg function, which is called when the transducer
 * initializes. Any stateful initialization of the predicate MUST be done in
 * this function and the function MUST return a 1-arg function, the actual
 * predicate applied to each value.
 *
 * Also see: {@link throttleTime}.
 *
 * @param pred -
 */
export declare function throttle<T>(pred: StatefulPredicate<T>): Transducer<T, T>;
export declare function throttle<T>(pred: StatefulPredicate<T>, src: Iterable<T>): IterableIterator<T>;
//# sourceMappingURL=throttle.d.ts.map