import type { Transducer } from "./api.js";
/**
 * Stateful transducer which accepts any input and flips between given
 * `on` / `off` values for every value received. The `initial` state can
 * be optionally provided (default: false) and must be given if used as
 * an iterator.
 *
 * @example
 * ```ts tangle:../export/toggle.ts
 * import { toggle } from "@thi.ng/transducers";
 *
 * console.log(
 *   [...toggle(1, 0, false, [1, 2, 3, 4])]
 * );
 * // [ 1, 0, 1, 0 ]
 *
 * console.log(
 *   [...toggle("on", "off", true, [1, 2, 3, 4])]
 * );
 * // [ 'off', 'on', 'off', 'on' ]
 * ```
 *
 * @param on - result for "on" state
 * @param off - result for "off" state
 * @param initial - initial state
 */
export declare function toggle<T>(on: T, off: T, initial?: boolean): Transducer<any, T>;
export declare function toggle<T>(on: T, off: T, initial: boolean, src: Iterable<any>): IterableIterator<boolean>;
//# sourceMappingURL=toggle.d.ts.map