import { isIterable } from "@thi.ng/checks/is-iterable";
import { iterator1 } from "./iterator.js";
function toggle(on, off, initial = false, src) {
  return isIterable(src) ? iterator1(toggle(on, off, initial), src) : ([init, complete, reduce]) => {
    let state = initial;
    return [
      init,
      complete,
      (acc) => reduce(acc, (state = !state) ? on : off)
    ];
  };
}
export {
  toggle
};
