import type { Comparator, TypedArray } from "@thi.ng/api";
/**
 * Implementation of the Floyd-Rivest selection algorithm to partially find &
 * sort the `k`th smallest elements in given array, according to supplied
 * comparator.
 *
 * @remarks
 * `k` is the desired index value, where `buf[k]` is the `(k+1)`th smallest
 * element when `left=0` (default).
 *
 * **IMPORTANT:** Mutates (partially sorts) given array such that all items in
 * the `[left, k]` interval are the smallest.
 *
 * @example
 * ```ts tangle:../export/floyd-rivest.ts
 * import { floydRivest } from "@thi.ng/arrays";
 *
 * console.log(
 *   floydRivest([5, 3, -1, -10, 20, 7, 0, 4, 2], 3)
 * );
 * // [ -10, 0, -1, 2, 3,  4, 5, 20, 7 ]
 * ```
 *
 * Based on pseudo-code from:
 * - https://en.wikipedia.org/wiki/Floyd%E2%80%93Rivest_algorithm
 *
 * @param buf
 * @param k
 * @param cmp
 * @param left
 * @param right
 */
export declare function floydRivest<T>(buf: T[], k?: number, cmp?: Comparator<T>, left?: number, right?: number): T[];
export declare function floydRivest<T extends TypedArray>(buf: T, k?: number, cmp?: Comparator<number>, left?: number, right?: number): T;
//# sourceMappingURL=floyd-rivest.d.ts.map