import type { Comparator, Fn, Keys, Val1 } from "@thi.ng/api";
/**
 * HOF comparator. Returns new comparator to sort objects by given `key`
 * and with optional comparator `cmp` (default: {@link compare}).
 *
 * @param key -
 * @param cmp -
 */
export declare function compareByKey<T, K extends Keys<T>>(key: K, cmp?: Comparator<Val1<T, K>>): Comparator<T>;
export declare function compareByKey<T, A>(a: Fn<T, A>, cmp?: Comparator<A>): Comparator<T>;
/**
 * HOF comparator. Returns new comparator to sort objects by given keys
 * `a` (major), `b` (minor) and with optional comparators (default for
 * each: {@link compare}).
 *
 * @param major -
 * @param minor -
 * @param cmpA -
 * @param cmpB -
 */
export declare function compareByKeys2<T, A extends Keys<T>, B extends Keys<T>>(major: A, minor: B, cmpA?: Comparator<Val1<T, A>>, cmpB?: Comparator<Val1<T, B>>): Comparator<T>;
export declare function compareByKeys2<T, A, B>(major: Fn<T, A>, minor: Fn<T, B>, cmpA?: Comparator<A>, cmpB?: Comparator<B>): Comparator<T>;
/**
 * Same as {@link compareByKeys2}, but for 3 sort keys / comparators.
 *
 * @param major -
 * @param minor -
 * @param patch -
 * @param cmpA -
 * @param cmpB -
 * @param cmpC -
 */
export declare function compareByKeys3<T, A extends Keys<T>, B extends Keys<T>, C extends Keys<T>>(major: A, minor: B, patch: C, cmpA?: Comparator<Val1<T, A>>, cmpB?: Comparator<Val1<T, B>>, cmpC?: Comparator<Val1<T, C>>): Comparator<T>;
export declare function compareByKeys3<T, A, B, C>(major: Fn<T, A>, minor: Fn<T, B>, patch: Fn<T, C>, cmpA?: Comparator<A>, cmpB?: Comparator<B>, cmpC?: Comparator<C>): Comparator<T>;
/**
 * Same as {@link compareByKeys2}, but for 4 sort keys / comparators.
 *
 * @param a -
 * @param b -
 * @param c -
 * @param d -
 * @param cmpA -
 * @param cmpB -
 * @param cmpC -
 * @param cmpD -
 */
export declare function compareByKeys4<T, A extends Keys<T>, B extends Keys<T>, C extends Keys<T>, D extends Keys<T>>(a: A, b: B, c: C, d: D, cmpA?: Comparator<Val1<T, A>>, cmpB?: Comparator<Val1<T, B>>, cmpC?: Comparator<Val1<T, C>>, cmpD?: Comparator<Val1<T, D>>): Comparator<T>;
export declare function compareByKeys4<T, A, B, C, D>(a: Fn<T, A>, b: Fn<T, B>, c: Fn<T, C>, d: Fn<T, D>, cmpA?: Comparator<A>, cmpB?: Comparator<B>, cmpC?: Comparator<C>, cmpD?: Comparator<D>): Comparator<T>;
//# sourceMappingURL=keys.d.ts.map