import type { Predicate2 } from "@thi.ng/api";
export type Operator = "=" | "!=" | "<" | "<=" | ">=" | ">";
export declare const OPERATORS: Record<Operator, Predicate2<string> | Predicate2<number>>;
/**
 * Takes a comparison operator (either as string alias or function) and the RHS arg
 * for it, returns a new function for given operator which only takes a single
 * arg (i.e. the LHS of the operator) and always coerces it to a string before
 * applying the operator.
 *
 * @remarks
 * See {@link numericOp} for related functionality.
 *
 * @example
 * ```ts tangle:../export/string-op.ts
 * import { stringOp } from "@thi.ng/compare";
 *
 * const equalsABC = stringOp("=", "abc");
 *
 * ["xyz", "abc", "def"].map(equalsABC)
 * // [ false, true, false ]
 *
 * class X {
 *   constructor(public body: string) {}
 *
 *   toString() {
 *     return this.body;
 *   }
 * }
 *
 * equalsABC(new X("abc"))
 * // true
 * ```
 *
 * @param op
 * @param x
 */
export declare const stringOp: (op: Operator | Predicate2<string>, x: string) => (y: any) => boolean;
/**
 * Similar to {@link stringOp}, but for numeric args. Takes a comparison
 * operator (either as string alias or function) and the RHS arg for it, returns
 * a new function for given operator which only takes a single arg (i.e. the LHS
 * of the operator) and then checks if that arg is a number before applying the
 * operator. For non-numeric args, the returned function will always return
 * false.
 *
 * @example
 * ```ts tangle:../export/numeric-op.ts
 * import { numericOp } from "@thi.ng/compare";
 *
 * const lessThan42 = numericOp("<", 42);
 *
 * lessThan42(41)
 * // true
 *
 * lessThan42("41")
 * // false
 *
 * lessThan42([41])
 * // false
 * ```
 *
 * @param op
 * @param x
 */
export declare const numericOp: (op: Operator | Predicate2<number>, x: number) => (y: any) => boolean;
export declare function eq(a: string, b: string): boolean;
export declare function eq(a: number, b: number): boolean;
export declare function neq(a: string, b: string): boolean;
export declare function neq(a: number, b: number): boolean;
export declare function lt(a: string, b: string): boolean;
export declare function lt(a: number, b: number): boolean;
export declare function lte(a: string, b: string): boolean;
export declare function lte(a: number, b: number): boolean;
export declare function gte(a: string, b: string): boolean;
export declare function gte(a: number, b: number): boolean;
export declare function gt(a: string, b: string): boolean;
export declare function gt(a: number, b: number): boolean;
//# sourceMappingURL=ops.d.ts.map