import type { Comparator } from "@thi.ng/api";
/**
 * Comparator intended for short tag-like strings containing compounds of words
 * and numbers (e.g. `2d` or `base36`). Splits strings at first digit/non-digit
 * boundary and if both inputs happen to contain such a boundary, compares
 * inputs pairwise, comparing each lexicographically (ascending order for
 * numeric parts)
 *
 * @example
 * ```ts tangle:../export/compare-lex.ts
 * import { compareLex } from "@thi.ng/compare";
 *
 * const sr = ["2d", "16bit", "base36", "8bit", "1d", "base8"];
 *
 * console.log("native", [...src].sort());
 * // [ "16bit", "1d", "2d", "8bit", "base36", "base8" ]
 *
 * console.log("compareLex", [...src].sort(compareLex));
 * // [ "1d", "2d", "8bit", "16bit", "base8", "base36" ]
 * ```
 *
 * @param a
 * @param b
 */
export declare const compareLex: Comparator<string>;
//# sourceMappingURL=string.d.ts.map