const threadFirst = (init, ...fns) => fns.reduce(
  (acc, expr) => typeof expr === "function" ? expr(acc) : expr[0](acc, ...expr.slice(1)),
  init
);
const threadFirstAsync = async (init, ...fns) => {
  let res = await init;
  for (let expr of fns) {
    res = await (typeof expr === "function" ? expr(res) : expr[0](res, ...expr.slice(1)));
  }
  return res;
};
export {
  threadFirst,
  threadFirstAsync
};
