import type { Maybe } from "@thi.ng/api";
import { type Type, type TypedArray, type TypedArrayTypeMap } from "@thi.ng/api/typedarray";
import type { IMemPoolArray } from "./api.js";
/**
 * Stub/polyfill implementation of {@link IMemPoolArray}, merely delegating to
 * JS typed array ctors with no further management of returned arrays.
 */
export declare class NativePool implements IMemPoolArray {
    mallocAs<T extends Type>(type: T, num: number): Maybe<TypedArrayTypeMap[T]>;
    callocAs<T extends Type>(type: T, num: number, fill?: number): Maybe<TypedArrayTypeMap[T]>;
    reallocArray<T extends TypedArray>(src: T, num: number): Maybe<T>;
    free(_: number | TypedArray): boolean;
    freeAll(): void;
    release(): boolean;
}
//# sourceMappingURL=native.d.ts.map