import type { FnN, FnN2, FnN3, FnU2 } from "@thi.ng/api";
/**
 * Returns a value with the magnitude of `x` and the sign of `y`.
 *
 * @param x -
 * @param y -
 */
export declare const copysign: FnN2;
/**
 * Returns `2^x`.
 *
 * @param x -
 */
export declare const exp2: FnN;
/**
 * Returns the positive difference between `x` and `y`, i.e. `x - y` iff `x > y`,
 * otherwise zero.
 *
 * @param x -
 * @param y -
 */
export declare const fdim: FnN2;
/**
 * Returns `x * y + z`.
 *
 * @param x -
 * @param y -
 * @param z -
 */
export declare const fma: FnN3;
/**
 * Similar to {@link mod}, {@link remainder}. Returns `x - y * trunc(x / y)`,
 * i.e. essentially the same as JS `%` operator. Result will always have the
 * sign of `x`.
 *
 * @remarks
 * **Caution:** Due to the introduction of libc math functions in v4.0.0 and the
 * resulting name/behavior clashes between the modulo logic in JS, C & GLSL, the
 * previous `fmod` function has been renamed to {@link mod} to align w/ its GLSL
 * version and now exhibits a different behavior to this current {@link fmod}
 * function.
 *
 * Reference: https://www.cplusplus.com/reference/cmath/fmod/
 *
 * @param x -
 * @param y -
 */
export declare const fmod: FnN2;
/**
 * Inverse op of {@link ldexp}. Breaks the number `x` into its binary
 * significand (a floating point with an abs value in `[0.5,1.0)` interval and
 * an integral exponent for 2, such that: `x = significand * 2^exp`. Returns
 * tuple of `[sig, exp]`.
 *
 * @remarks
 * - If `x` is zero, both parts (significand and exponent) are zero.
 * - If `x` is negative, the significand returned by this function is negative.
 *
 * Based on:
 * https://github.com/locutusjs/locutus/blob/master/src/c/math/frexp.js
 *
 * @param x -
 */
export declare const frexp: (x: number) => number[];
/**
 * Inverse op of {@link frexp}. Returns `x * 2^exp`
 *
 * @param x -
 * @param exp -
 */
export declare const ldexp: FnN2;
/**
 * Similar to {@link fmod}, {@link mod}. Returns `x - y * round(x / y)`.
 *
 * @remarks
 * https://www.cplusplus.com/reference/cmath/remainder/
 *
 * @param x -
 * @param y -
 */
export declare const remainder: FnN2;
/**
 * Computes both the quotient and remainder of the integer division of the
 * numerator `x` by the denominator `y`.
 *
 * @param x -
 * @param y -
 */
export declare const ldiv: FnU2<number, [number, number]>;
//# sourceMappingURL=libc.d.ts.map