import type { Fn, Fn2, Fn3, Fn4 } from "@thi.ng/api";
import type { MapLike } from "./api.js";
/**
 * Function memoization for arbitrary argument counts. Returns augmented
 * function, which uses the given `Map` implementation to obtain and store
 * memoized result of given args. Supports generics for up to 4 args (otherwise
 * untyped).
 *
 * @remarks
 * **Important:** It only makes sense to use `Map` types which support value
 * (rather than object) equality, e.g. those provided by
 * [`thi.ng/associative`](https://thi.ng/associative). Using a native `Map` type
 * here will lead to memory leaks!
 *
 * Also see {@link memoizeJ}, {@link memoize1}, {@link memoizeO}.
 *
 * @param fn -
 * @param cache -
 */
export declare function memoize<A, B>(fn: Fn<A, B>, cache: MapLike<A, B>): Fn<A, B>;
export declare function memoize<A, B, C>(fn: Fn2<A, B, C>, cache: MapLike<[A, B], C>): Fn2<A, B, C>;
export declare function memoize<A, B, C, D>(fn: Fn3<A, B, C, D>, cache: MapLike<[A, B, C], D>): Fn3<A, B, C, D>;
export declare function memoize<A, B, C, D, E>(fn: Fn4<A, B, C, D, E>, cache: MapLike<[A, B, C, D], E>): Fn4<A, B, C, D, E>;
//# sourceMappingURL=memoize.d.ts.map