import type { IBuffered, ICopy } from "@thi.ng/api";
import type { ISeedable } from "./api.js";
import { ARandom } from "./arandom.js";
/**
 * Simple Fast Counter PRNG (32bit version)
 *
 * @remarks
 * References:
 * - http://pracrand.sourceforge.net/
 */
export declare class SFC32 extends ARandom implements IBuffered<Uint32Array>, ICopy<SFC32>, ISeedable<ArrayLike<number>> {
    buffer: Uint32Array;
    constructor(seed?: ArrayLike<number>);
    copy(): SFC32;
    bytes(): Uint8Array;
    int(): number;
    seed(seed: ArrayLike<number>): this;
}
//# sourceMappingURL=sfc32.d.ts.map