/**
 * Removes all ANSI control sequences from given string.
 *
 * @example
 * ```ts tangle:../export/strip-ansi.ts
 * import { stripAnsi } from "@thi.ng/strings";
 *
 * console.log(
 *   stripAnsi("\x1B[32mhello\x1B[0m \x1B[91mworld\x1B[0m!")
 * );
 * // 'hello world!'
 * ```
 *
 * @param x -
 */
export declare const stripAnsi: (x: string) => string;
/**
 * Returns true iff `x` contains ANSI control sequences.
 *
 * @param x -
 */
export declare const isAnsi: (x: string) => boolean;
/**
 * Returns true iff `x` starts w/ an ANSI control sequence.
 *
 * @param x -
 */
export declare const isAnsiStart: (x: string) => boolean;
/**
 * Returns true iff `x` ends w/ an ANSI control sequence.
 *
 * @param x -
 */
export declare const isAnsiEnd: (x: string) => boolean;
/**
 * Returns length of `x` excluding any ANSI control sequences (via
 * {@link stripAnsi}).
 *
 * @param x -
 */
export declare const lengthAnsi: (x: string) => number;
//# sourceMappingURL=ansi.d.ts.map