import type { FnS, Stringer } from "./api.js";
/**
 * Uppercase string formatter.
 *
 * @param x - string to transform
 */
export declare const upper: FnS;
/**
 * Lowercase string formatter.
 *
 * @param x - string to transform
 */
export declare const lower: FnS;
/**
 * String formatter which capitalizes first character.
 *
 * @param x - string to transform
 */
export declare const capitalize: FnS;
/**
 * Converts a CamelCase string into kebab case, with optional custom
 * delimiter (`-` by default).
 *
 * @example
 * ```ts tangle:../export/kebab.ts
 * import { kebab } from "@thi.ng/strings";
 *
 * console.log(
 *   kebab("FooBar23Baz")
 * );
 * // "foo-bar23-baz"
 * ```
 *
 * @param x -
 * @param delim -
 */
export declare const kebab: Stringer<string>;
/**
 * Short for {@link kebab} using `_` as delimiter.
 *
 * @param x -
 */
export declare const snake: FnS;
/**
 * Uppercase version of {@link snake}.
 *
 * @param x -
 */
export declare const upperSnake: FnS;
/**
 * Converts a kebab-case or snake_case string into CamelCase. Uses `-`
 * as default delimiter.
 *
 * @param x -
 * @param delim -
 */
export declare const camel: Stringer<string>;
//# sourceMappingURL=case.d.ts.map