import type { Stringer } from "./api.js";
/**
 * Returns {@link Stringer} which formats numbers to given precision. If
 * `special` is true, then exceptional handling for:
 *
 * - NaN => "NaN"
 * - Infinity => "+/-∞"
 *
 * @param len - number of fractional digits
 * @param special - true, if special handling for NaN/Infinity values
 */
export declare const float: (prec: number, special?: boolean) => Stringer<number>;
/**
 * Similar to `float`, returns {@link Stringer} which formats numbers to given
 * character width & precision. Uses scientific notation if needed.
 *
 * Default precision: 3 fractional digits
 */
export declare const floatFixedWidth: (width: number, prec?: number) => Stringer<number>;
//# sourceMappingURL=float.d.ts.map