import type { Stringer } from "./api.js";
/**
 * Returns a {@link Stringer} which formats given numbers to `radix`, `len` and
 * with optional prefix (not included in `len`).
 *
 * @remarks
 * Only bases 2 - 36 are supported, due to native `Number.toString()`
 * limitations.
 *
 * @param radix -
 * @param len -
 * @param prefix -
 */
export declare const radix: (radix: number, len: number, prefix?: string) => Stringer<number>;
/**
 * 8bit binary conversion preset.
 */
export declare const B8: Stringer<number>;
/**
 * 16bit binary conversion preset.
 */
export declare const B16: Stringer<number>;
/**
 * 32bit binary conversion preset.
 */
export declare const B32: Stringer<number>;
/**
 * 8bit hex conversion preset.
 * Assumes unsigned inputs.
 */
export declare const U8: (x: number) => string;
/**
 * 16bit hex conversion preset.
 * Assumes unsigned inputs.
 */
export declare const U16: (x: number) => string;
/**
 * 24bit hex conversion preset.
 * Assumes unsigned inputs.
 */
export declare const U24: (x: number) => string;
/**
 * 32bit hex conversion preset.
 * Assumes unsigned inputs.
 */
export declare const U32: (x: number) => string;
/**
 * 64bit hex conversion preset (2x 32bit ints)
 * Assumes unsigned inputs.
 */
export declare const U64: (hi: number, lo: number) => string;
//# sourceMappingURL=radix.d.ts.map