/**
 * Returns a ruler-like string of given `width`, using `a` character for major
 * ticks and `b` for minor ticks.
 *
 * @example
 * ```ts tangle:../export/ruler.ts
 * import { ruler } from "@thi.ng/strings";
 *
 * console.log(ruler(40))
 * // |''''|''''|''''|''''|''''|''''|''''|''''
 *
 * console.log(ruler(40, 8, "!", "."))
 * // !.......!.......!.......!.......!.......
 * ```
 *
 * @param width -
 * @param major -
 * @param a -
 * @param b -
 */
export declare const ruler: (width: number, major?: number, a?: string, b?: string) => string;
/**
 * Returns a grid of given `cols` x `rows` as string, each cell of size `w` x
 * `h`. The optional `chars` can be used to customize the grid.
 *
 * @example
 * ```ts tangle:../export/grid.ts
 * import { grid } from "@thi.ng/strings";
 *
 * console.log(grid(3, 3, 4, 2));
 * // +---+---+---+
 * // |   |   |   |
 * // +---+---+---+
 * // |   |   |   |
 * // +---+---+---+
 * // |   |   |   |
 * // +---+---+---+
 *
 * console.log(grid(3, 3, 4, 2, "*_/"));
 * // *___*___*___*
 * // /   /   /   /
 * // *___*___*___*
 * // /   /   /   /
 * // *___*___*___*
 * // /   /   /   /
 * // *___*___*___*
 *
 * console.log(grid(3, 2, 3, 3, "+  #"));
 * // +  +  +
 * //  ## ##
 * //  ## ##
 * // +  +  +
 * //  ## ##
 * //  ## ##
 * // +  +  +
 * ```
 *
 * @param cols -
 * @param rows -
 * @param w -
 * @param h -
 * @param chars -
 */
export declare const grid: (cols: number, rows: number, w: number, h: number, [a, b, c, d]?: string) => string;
//# sourceMappingURL=ruler.d.ts.map