import type { Stringer } from "./api.js";
/**
 * Based on:
 * https://medium.com/@matthagemann/the-ultimate-way-to-slugify-a-url-string-in-javascript-b8e4a0d849e1
 *
 * @example
 * ```ts tangle:../export/slugify.ts
 * import { slugify } from "@thi.ng/strings";
 *
 * console.log(
 *   slugify("Me, myself (& ëye) 😀!")
 * );
 * // "me-myself-and-eye"
 * ```
 *
 * @param str -
 */
export declare const slugify: Stringer<string>;
/**
 * Similar to {@link slugify}, however uses GitHub's anchor naming rules
 * for headings in markdown files (AFAICT).
 *
 * @example
 * ```ts tangle:../export/slugify-gh.ts
 * import { slugifyGH } from "@thi.ng/strings";
 *
 * console.log(
 *   slugifyGH("Me, myself (& ëye) 😀!")
 * );
 * // "me-myself--ëye-"
 * ```
 *
 * @param str -
 */
export declare const slugifyGH: (str: string) => string;
//# sourceMappingURL=slugify.d.ts.map