import type { IWordSplit, WordWrapOpts } from "./api.js";
/**
 * Internal representation of a single line (for word wrapping purposes). A thin
 * wrapper of individual word and the _logical_ line length (rather than the
 * actually string width).
 */
export declare class Line {
    n: number;
    w: string[];
    constructor(word?: string, n?: number);
    add(word: string, n?: number): this;
    toString(): string;
}
/**
 * (Default) wordwrap word splitting strategy for plain text.
 */
export declare const SPLIT_PLAIN: IWordSplit;
/**
 * Wordwrap word splitting strategy for text containing ANSI control sequences.
 */
export declare const SPLIT_ANSI: IWordSplit;
/**
 * Wordwraps a single-`line` string using provided options. Returns array of
 * {@link Line} objects, which can simply be `.join("\n")`ed to convert back
 * into text.
 *
 * @see {@link wordWrap} for main user facing alternative.
 *
 * @param line -
 * @param opts -
 * @param acc -
 *
 * @internal
 */
export declare const wordWrapLine: (line: string, opts: Partial<WordWrapOpts>, acc?: Line[]) => Line[];
/**
 * Wordwraps a multi-`line` string using provided options. Returns array of
 * {@link Line} objects, which can simply be `.join("\n")`ed to convert back
 * into text.
 *
 * @see {@link wordWrap} for main user facing alternative.
 *
 * @param lines -
 * @param opts -
 */
export declare const wordWrapLines: (lines: string, opts: Partial<WordWrapOpts>) => Line[];
/**
 * Same as {@link wordWrapLines}, but returns wordwrapped result as string. See
 * {@link WordWrapOpts} for options.
 *
 * @param str -
 * @param opts -
 */
export declare const wordWrap: (str: string, opts: Partial<WordWrapOpts>) => string;
//# sourceMappingURL=word-wrap.d.ts.map