import { compR } from "@thi.ng/transducers/compr";
import { iterator, __iter } from "@thi.ng/transducers/iterator";
import { isReduced } from "@thi.ng/transducers/reduced";
function bits(...args) {
  return __iter(bits, args, iterator) || ((rfn) => {
    const reduce = rfn[2];
    const size = args[0] || 8;
    const msb = args[1] !== false;
    return compR(
      rfn,
      msb ? (acc, x) => {
        for (let i = size; i-- > 0 && !isReduced(acc); ) {
          acc = reduce(acc, x >>> i & 1);
        }
        return acc;
      } : (acc, x) => {
        for (let i = 0; i < size && !isReduced(acc); i++) {
          acc = reduce(acc, x >>> i & 1);
        }
        return acc;
      }
    );
  });
}
export {
  bits
};
