import type { Transducer } from "@thi.ng/transducers";
/**
 * Transducer which decodes a byte input sequence into UTF-8 characters. Also
 * see {@link utf8Encode} for reverse transformation.
 */
export declare function utf8Decode(): Transducer<number, string>;
export declare function utf8Decode(src: Iterable<number>): string;
/**
 * Transducer which encodes UTF-8 characters into a byte sequence.
 *
 * Also see {@link utf8Decode} for reverse transformation.
 *
 * @example
 * ```ts tangle:../export/utf8-encode.ts
 * import { hexDump, utf8Encode } from "@thi.ng/transducers-binary";
 * import { comp, str, transduce } from "@thi.ng/transducers";
 *
 * const res = transduce(
 *   comp(utf8Encode(), hexDump({ cols: 8 })),
 *   str("\n"),
 *   "¡Hola niña! 😀"
 * );
 *
 * console.log(res);
 * // 00000000 | c2 a1 48 6f 6c 61 20 6e | ..Hola n
 * // 00000008 | 69 c3 b1 61 21 20 f0 9f | i..a! ..
 * // 00000010 | 98 80 00 00 00 00 00 00 | ........
 * ```
 */
export declare function utf8Encode(): Transducer<string, number>;
export declare function utf8Encode(src: string): Uint8Array;
/**
 * Re-export of [utf8Length()](https://docs.thi.ng/umbrella/strings/functions/utf8Length.html).
 *
 * @deprecated migrated to thi.ng/strings pkg
 */
export declare const utf8Length: (str: string) => number;
//# sourceMappingURL=utf8.d.ts.map