import type { IObjectOf } from "@thi.ng/api";
import type { Reducer } from "./api.js";
/**
 * Reducer accepting values of any type and assigning them to auto-labeled keys
 * in an object. Keys consist of given `prefix` and monotonically increasing ID.
 *
 * @example
 * ```ts tangle:../export/auto-obj.ts
 * import { autoObj } from "@thi.ng/transducers";
 *
 * console.log(
 *   autoObj("id", ["foo", "bar", "baz"])
 * );
 * // { id0: "foo", id1: "bar", id2: "baz" }
 * ```
 *
 * @param prefix - shared prefix
 */
export declare function autoObj<T>(prefix: string): Reducer<T, IObjectOf<T>>;
export declare function autoObj<T>(prefix: string, src: Iterable<T>): IObjectOf<T>;
//# sourceMappingURL=auto-obj.d.ts.map