import { isIterable } from "@thi.ng/checks/is-iterable";
import { compR } from "./compr.js";
import { iterator1 } from "./iterator.js";
function benchmark(src) {
  return isIterable(src) ? iterator1(benchmark(), src) : (rfn) => {
    const r = rfn[2];
    let prev = Date.now();
    return compR(rfn, (acc, _) => {
      const t = Date.now();
      const x = t - prev;
      prev = t;
      return r(acc, x);
    });
  };
}
export {
  benchmark
};
