import { SEMAPHORE } from "@thi.ng/api/api";
import { compR } from "./compr.js";
import { __iter } from "./iterator.js";
import { ensureReduced } from "./reduced.js";
function converge(...args) {
  return __iter(converge, args) || ((rfn) => {
    const r = rfn[2];
    const pred = args[0];
    let prev = SEMAPHORE;
    let done = false;
    return compR(rfn, (acc, x) => {
      if (done || prev !== SEMAPHORE && pred(prev, x)) {
        done = true;
        return ensureReduced(r(acc, x));
      }
      prev = x;
      return r(acc, x);
    });
  });
}
export {
  converge
};
