import { SEMAPHORE } from "@thi.ng/api/api";
import { repeat } from "./repeat.js";
function* extendSides(src, numLeft = 1, numRight = numLeft) {
  let prev = SEMAPHORE;
  for (let x of src) {
    if (numLeft > 0 && prev === SEMAPHORE) {
      yield* repeat(x, numLeft);
      numLeft = 0;
    }
    yield x;
    prev = x;
  }
  if (numRight > 0 && prev !== SEMAPHORE) {
    yield* repeat(prev, numRight);
  }
}
export {
  extendSides
};
