import type { Fn, Predicate2 } from "@thi.ng/api";
import type { Transducer } from "./api.js";
export interface FilterFuzzyOpts<A, B> {
    /**
     * Key extractor function.
     */
    key: Fn<A, ArrayLike<B>>;
    /**
     * Equivalence predicate function.
     */
    equiv: Predicate2<any>;
}
/**
 * Returns transducer which calls
 * [`fuzzyMatch()`](https://docs.thi.ng/umbrella/arrays/functions/fuzzyMatch.html)
 * for each value and discards all non-matching values.
 *
 * @remarks
 * The `key` option function can be used to extract/produce the actual value
 * used for the search. The `equiv` option predicate can be used to customize
 * item equality checking. Uses
 * [`equiv()`](https://docs.thi.ng/umbrella/equiv/functions/equiv.html) by
 * default.
 *
 * @example
 * ```ts tangle:../export/filter-fuzzy.ts
 * import { filterFuzzy } from "@thi.ng/transducers";
 *
 * console.log(
 *   [...filterFuzzy("ho", ["hello", "hallo", "hey", "heyoka"])]
 * );
 * // ["hello", "hallo", "heyoka"]
 * ```
 *
 * @param query -
 * @param opts -
 */
export declare function filterFuzzy<A, B>(query: ArrayLike<B>, opts?: Partial<FilterFuzzyOpts<A, B>>): Transducer<A, A>;
export declare function filterFuzzy<A, B>(query: ArrayLike<B>, src: Iterable<A>): IterableIterator<A>;
export declare function filterFuzzy<A, B>(query: ArrayLike<B>, opts: Partial<FilterFuzzyOpts<A, B>>, src: Iterable<A>): IterableIterator<A>;
//# sourceMappingURL=filter-fuzzy.d.ts.map