import { __groupByOpts } from "./internal/group-opts.js";
import { $$reduce } from "./reduce.js";
function groupByObj(...args) {
  const res = $$reduce(groupByObj, args);
  if (res) return res;
  const opts = __groupByOpts(args[0]);
  const [_init, complete, _reduce] = opts.group;
  return [
    () => ({}),
    (acc) => {
      for (let k in acc) {
        acc[k] = complete(acc[k]);
      }
      return acc;
    },
    (acc, x) => {
      const k = opts.key(x);
      acc[k] = acc[k] ? _reduce(acc[k], x) : _reduce(_init(), x);
      return acc;
    }
  ];
}
export {
  groupByObj
};
