import { isIterable } from "@thi.ng/checks/is-iterable";
import { comp } from "./comp.js";
import { iterator } from "./iterator.js";
import { map } from "./map.js";
import { mapcat } from "./mapcat.js";
import { normRange } from "./norm-range.js";
import { partition } from "./partition.js";
function interpolate(fn, window, n, src) {
  return isIterable(src) ? iterator(interpolate(fn, window, n), src) : comp(
    partition(window, 1),
    mapcat((chunk) => map((t) => fn(chunk, t), normRange(n, false)))
  );
}
export {
  interpolate
};
