import type { IObjectOf } from "@thi.ng/api";
/**
 * Similar to {@link permutations}, however takes an object with each
 * key specifying an array of its possible values. Yields an iterable of
 * objects of all value permutations.
 *
 * @remarks
 * The resulting object type will be derived from the value types in the
 * given `spec` object.
 *
 * The order of resulting permutations is not guaranteed and depending
 * on the VM's iteration behavior of `Object.keys()`.
 *
 * @example
 * ```ts tangle:../export/key-permutations.ts
 * import { keyPermutations } from "@thi.ng/transducers";
 *
 * console.log(
 *   [...keyPermutations({ a: [1, 2], b: [true, false], c: ["X", "Y"] })]
 * );
 * // [
 * //   { a: 1, b: true, c: 'X' },
 * //   { a: 1, b: true, c: 'Y' },
 * //   { a: 1, b: false, c: 'X' },
 * //   { a: 1, b: false, c: 'Y' },
 * //   { a: 2, b: true, c: 'X' },
 * //   { a: 2, b: true, c: 'Y' },
 * //   { a: 2, b: false, c: 'X' },
 * //   { a: 2, b: false, c: 'Y' }
 * // ]
 * ```
 *
 * @param spec - permutation spec object
 */
export declare const keyPermutations: <T extends IObjectOf<any[]>>(spec: T) => IterableIterator<{ [k in keyof T]: T[k][0]; }>;
//# sourceMappingURL=key-permutations.d.ts.map