import type { Fn } from "@thi.ng/api";
import type { Transducer } from "./api.js";
/**
 * Transducer. Similar to {@link map}, but only transforms every `n`-th input
 * value and passes intermediate values unchanged downstream.
 *
 * @remarks
 * The optional `offset` arg can be used to adjust the number of inputs before
 * the first transformation occurs (default 0).
 *
 * @example
 * ```ts tangle:../export/map-nth.ts
 * import { mapNth, range } from "@thi.ng/transducers";
 *
 * console.log(
 *   [...mapNth(3, (x) => `*${x}*`, range(1, 10))]
 * );
 * // [ "*1*", 2, 3, "*4*", 5, 6, "*7*", 8, 9 ]
 *
 * // with offset
 * console.log(
 *   [...mapNth(3, 5, (x) => x * 100, range(1, 10))]
 * );
 * // [ 1, 2, 3, 4, 5, 600, 7, 8, 900 ]
 * ```
 *
 * @param n - step size
 * @param fn - transformation function
 */
export declare function mapNth<A, B>(n: number, fn: Fn<A, B>): Transducer<A, A | B>;
export declare function mapNth<A, B>(n: number, offset: number, fn: Fn<A, B>): Transducer<A, A | B>;
export declare function mapNth<A, B>(n: number, fn: Fn<A, B>, src: Iterable<A>): IterableIterator<A | B>;
export declare function mapNth<A, B>(n: number, offset: number, fn: Fn<A, B>, src: Iterable<A>): IterableIterator<A | B>;
//# sourceMappingURL=map-nth.d.ts.map