import type { Fn, IObjectOf } from "@thi.ng/api";
import type { Transducer } from "./api.js";
/**
 * Transducer. Similar to {@link map}, but expects object values and the given
 * function `fn` is applied to each enumerable property value and the results
 * reassigned to their original keys.
 *
 * @remarks
 * By default, a shallow copy of the source object is created. The resulting
 * object is then used as the result of this transducer.
 *
 * @example
 * ```ts tangle:../export/map-vals.ts
 * import { mapVals } from "@thi.ng/transducers";
 *
 * console.log(
 *   [...mapVals((x)=> x * 10, [{a: 1, b: 2}, {c: 3, d: 4}])]
 * );
 * // [ { a: 10, b: 20 }, { c: 30, d: 40 } ]
 * ```
 *
 * @param fn -
 * @param copy - if true (default), creates a shallow copy of each incoming
 * value
 */
export declare function mapVals<A, B>(fn: Fn<A, B>, copy?: boolean): Transducer<IObjectOf<A>, IObjectOf<B>>;
export declare function mapVals<A, B>(fn: Fn<A, B>, src: Iterable<IObjectOf<A>>): IterableIterator<IObjectOf<B>>;
export declare function mapVals<A, B>(fn: Fn<A, B>, copy: boolean, src: Iterable<IObjectOf<A>>): IterableIterator<IObjectOf<B>>;
//# sourceMappingURL=map-vals.d.ts.map