import { __iter } from "./iterator.js";
import { map } from "./map.js";
function mapVals(...args) {
  const iter = __iter(mapVals, args);
  if (iter) {
    return iter;
  }
  const fn = args[0];
  const copy = args[1] !== false;
  return map((x) => {
    const res = copy ? {} : x;
    for (let k in x) {
      res[k] = fn(x[k]);
    }
    return res;
  });
}
export {
  mapVals
};
