import type { Fn } from "@thi.ng/api";
import type { Transducer } from "./api.js";
/**
 * Transducer. Applies mapping function `fn` to each received value and
 * passes result downstream to next reducer.
 *
 * @example
 * ```ts tangle:../export/map.ts
 * import { map } from "@thi.ng/transducers";
 *
 * console.log(
 *   [...map((x) => x * 10, [1, 2, 3])]
 * );
 * // [ 10, 20, 30 ]
 * ```
 *
 * @param fn - transformation function
 */
export declare function map<A, B>(fn: Fn<A, B>): Transducer<A, B>;
export declare function map<A, B>(fn: Fn<A, B>, src: Iterable<A>): IterableIterator<B>;
/**
 * Convenience wrapper for {@link map} to transform an iterable with given `fn`
 * and immediately collect results into an array.
 */
export declare const mapA: <A, B>(fn: Fn<A, B>, src: Iterable<A>) => B[];
//# sourceMappingURL=map.d.ts.map