import type { Fn2, Nullable } from "@thi.ng/api";
import type { Transducer } from "./api.js";
/**
 * Transducer. Similar to {@link mapcat}, but given `fn` takes two arguments:
 * `index` and `value` to transform.
 *
 * @remarks
 * An optional start index `offset` can be provided (default 0). Also see
 * {@link mapIndexed}.
 *
 * @param fn - transformation function
 * @param offset - initial index
 */
export declare function mapcatIndexed<A, B>(fn: Fn2<number, A, Nullable<Iterable<B>>>, offset?: number): Transducer<A, B>;
export declare function mapcatIndexed<A, B>(fn: Fn2<number, A, Nullable<Iterable<B>>>, src: Iterable<A>): IterableIterator<B>;
export declare function mapcatIndexed<A, B>(fn: Fn2<number, A, Nullable<Iterable<B>>>, offset: number, src: Iterable<A>): IterableIterator<B>;
//# sourceMappingURL=mapcat-indexed.d.ts.map