import type { Predicate } from "@thi.ng/api";
import type { Transducer } from "./api.js";
/**
 * Transducer. Applies given predicate `pred` to each incoming value and
 * collects values until the return value of the `fn` is truthy. Once this
 * happens yields chunk of buffered values.
 *
 * @example
 * ```ts tangle:../export/partition-when.ts
 * import { partitionWhen } from "@thi.ng/transducers";
 *
 * console.log(
 *   [...partitionWhen((x) => !!x, [0, 1, 0, 0, 1, 1, 0, 1])]
 * );
 * // [ [ 0 ], [ 1, 0, 0 ], [ 1 ], [ 1, 0 ], [ 1 ] ]
 * ```
 *
 * @param pred -
 * @param stateful -
 */
export declare function partitionWhen<T>(pred: Predicate<T> | (() => Predicate<T>), stateful?: boolean): Transducer<T, T[]>;
export declare function partitionWhen<T>(pred: Predicate<T> | (() => Predicate<T>), src: Iterable<T>): IterableIterator<T[]>;
export declare function partitionWhen<T>(pred: Predicate<T> | (() => Predicate<T>), stateful: boolean, src: Iterable<T>): IterableIterator<T[]>;
//# sourceMappingURL=partition-when.d.ts.map