import type { Transducer } from "./api.js";
/**
 * Transducer which looks up given `key` in each input and yields
 * sequence of these values.
 *
 * @example
 * ```ts tangle:../export/pluck.ts
 * import { pluck } from "@thi.ng/transducers";
 *
 * console.log(
 *   [...pluck("id", [{id: 1}, {id: 2}, {}])]
 * );
 * // [ 1, 2, undefined ]
 * ```
 *
 * @param key - property key
 */
export declare function pluck<A, B>(key: PropertyKey): Transducer<A, B>;
export declare function pluck<A, B>(key: PropertyKey, src: Iterable<A>): IterableIterator<B>;
//# sourceMappingURL=pluck.d.ts.map