import type { IReducible, ReductionFn } from "./api.js";
import { Reduced } from "./reduced.js";
export declare function range(): Range;
export declare function range(to: number): Range;
export declare function range(from: number, to: number): Range;
export declare function range(from: number, to: number, step: number): Range;
/**
 * Simple class wrapper around given range interval and implementing `Iterable`
 * and {@link IReducible} interfaces, the latter is used to accelerate use with
 * {@link reduce}.
 */
export declare class Range implements Iterable<number>, IReducible<number, any> {
    protected from: number;
    protected to: number;
    protected step: number;
    constructor(to: number);
    constructor(from: number, to: number);
    constructor(from: number, to: number, step: number);
    [Symbol.iterator](): Generator<number, void, unknown>;
    $reduce<T>(rfn: ReductionFn<number, T>, acc: T | Reduced<T>): T | Reduced<T>;
}
//# sourceMappingURL=range.d.ts.map