import { deref } from "@thi.ng/api/deref";
import { compR } from "./compr.js";
import { __iter } from "./iterator.js";
function slidingWindow(...args) {
  const iter = __iter(slidingWindow, args);
  if (iter) return iter;
  const size = args[0];
  const partial = args[1] !== false;
  return (rfn) => {
    const reduce = rfn[2];
    let buf = [];
    return compR(rfn, (acc, x) => {
      buf.push(x);
      const _size = deref(size);
      if (partial || buf.length >= _size) {
        acc = reduce(acc, buf);
        buf = buf.slice(buf.length >= _size ? 1 : 0, _size);
      }
      return acc;
    });
  };
}
export {
  slidingWindow
};
