import type { SortOpts, Transducer } from "./api.js";
/**
 * Transducer. Similar to {@link partitionSort}, however uses a sliding window
 * of size `n` and insertion sort instead of fully sorting window as done by
 * `partitionSort`.
 *
 * @example
 * ```ts tangle:../export/stream-sort.ts
 * import { streamSort } from "@thi.ng/transducers";
 *
 * console.log(
 *   [...streamSort(4, [5,9,2,6,4,1,3,8,7,0])]
 * );
 * // [ 2, 4, 1, 3, 5, 6, 0, 7, 8, 9 ]
 * ```
 *
 * @param n -
 * @param opts -
 */
export declare function streamSort<A, B>(n: number, opts?: Partial<SortOpts<A, B>>): Transducer<A, A>;
export declare function streamSort<A, B>(n: number, src: Iterable<A>): IterableIterator<A>;
export declare function streamSort<A, B>(n: number, opts: Partial<SortOpts<A, B>>, src: Iterable<A>): IterableIterator<A>;
//# sourceMappingURL=stream-sort.d.ts.map