import type { Fn } from "@thi.ng/api";
import type { Transducer } from "./api.js";
/**
 * Structfield definition: [name, number-of-inputs, transform?]
 */
export type StructField<T> = [string, number, Fn<T[], any>?];
/**
 * Higher-order transducer to converts linear input into structured
 * objects using given field specs and ordering.
 *
 * @remarks
 * A single field spec is an array of 2 or 3 items:
 *
 * `[name, size, transform?]`.
 *
 * If `transform` is given, it will be used to produce the final value
 * for this field. In the example below, it is used to unwrap the ID
 * field values, e.g. from `[123] => 123`
 *
 * @example
 * ```ts tangle:../export/struct.ts
 * import { push, struct, transduce } from "@thi.ng/transducers";
 *
 * const res = transduce(
 *     struct([["id", 1, (id) => id[0]], ["pos", 2], ["vel", 2], ["color", 4]]),
 *     push(),
 *     [0, 100, 200, -1, 0, 1, 0.5, 0, 1, 1, 0, 0, 5, 4, 0, 0, 1, 1]
 * );
 *
 * console.log(res);
 * // [
 * //   {
 * //     color: [ 1, 0.5, 0, 1 ],
 * //     vel: [ -1, 0 ],
 * //     pos: [ 100, 200 ],
 * //     id: 0,
 * //   }, {
 * //     color: [ 0, 0, 1, 1 ],
 * //     vel: [ 5, 4 ],
 * //     pos: [ 0, 0 ],
 * //     id: 1,
 * //   }
 * // ]
 * ```
 *
 * @param fields -
 */
export declare function struct<A, B>(fields: StructField<A>[]): Transducer<A, B>;
export declare function struct<A, B>(fields: StructField<A>[], src: Iterable<A>): IterableIterator<B>;
//# sourceMappingURL=struct.d.ts.map