import type { Transducer } from "./api.js";
/**
 * Transducer which only yields the last `n` values. Assumes
 * input source is finite (of course).
 *
 * @example
 * ```ts tangle:../export/take-last.ts
 * import { range, takeLast } from "@thi.ng/transducers";
 *
 * console.log(
 *   [...takeLast(3, range(10))]
 * );
 * // [ 7, 8, 9 ]
 * ```
 *
 * @param n -
 */
export declare function takeLast<T>(n: number): Transducer<T, T>;
export declare function takeLast<T>(n: number, src: Iterable<T>): IterableIterator<T>;
//# sourceMappingURL=take-last.d.ts.map