import { isIterable } from "@thi.ng/checks/is-iterable";
import { __drain } from "./internal/drain.js";
import { iterator } from "./iterator.js";
function takeLast(n, src) {
  return isIterable(src) ? iterator(takeLast(n), src) : ([init, complete, reduce]) => {
    const buf = [];
    return [
      init,
      __drain(buf, complete, reduce),
      (acc, x) => {
        if (buf.length === n) {
          buf.shift();
        }
        buf.push(x);
        return acc;
      }
    ];
  };
}
export {
  takeLast
};
