import type { Transducer } from "./api.js";
/**
 * Transducer which only yields the first `n` values and then terminates
 * transformation (by emitting a {@link reduced} value).
 *
 * @example
 * ```ts tangle:../export/take.ts
 * import { comp, iterator, map, range, take } from "@thi.ng/transducers";
 *
 * // pre-compose transducer which only takes first N items and then
 * // transforms only those via map()...
 * // apply to infinite range() counter
 * console.log(
 *   [...iterator(comp(take(5), map((x) => x * 10)), range())]
 * );
 * // [ 0, 10, 20, 30, 40 ]
 * ```
 *
 * @param n -
 */
export declare function take<T>(n: number): Transducer<T, T>;
export declare function take<T>(n: number, src: Iterable<T>): IterableIterator<T>;
//# sourceMappingURL=take.d.ts.map