import { isIterable } from "@thi.ng/checks/is-iterable";
import { compR } from "./compr.js";
import { iterator } from "./iterator.js";
import { ensureReduced, reduced } from "./reduced.js";
function take(n, src) {
  return isIterable(src) ? iterator(take(n), src) : (rfn) => {
    const r = rfn[2];
    let m = n;
    return compR(
      rfn,
      (acc, x) => --m > 0 ? r(acc, x) : m === 0 ? ensureReduced(r(acc, x)) : reduced(acc)
    );
  };
}
export {
  take
};
