import type { Transducer } from "./api.js";
/**
 * Time-based version of {@link throttle}. Ignores any new values in the `delay`
 * interval since the last accepted value.
 *
 * @remarks
 * Only to be used in async contexts and NOT with {@link transduce} directly.
 *
 * Also see:
 * - [`thi.ng/rstream`](https://thi.ng/rstream)
 * - [`thi.ng/csp`](https://thi.ng/csp).
 *
 * @param delay -
 */
export declare function throttleTime<T>(delay: number): Transducer<T, T>;
export declare function throttleTime<T>(delay: number, src: Iterable<T>): IterableIterator<T>;
//# sourceMappingURL=throttle-time.d.ts.map